
  /*
   *  Object %name    : extApp_qa_parser%
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:39:24 2008
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file includes qa external application parser  
   *
   *  \version parser.c#1:csrc:1
   *  \author avis
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/

#include "DX_VOS_BaseTypes.h"
#include "ExtApp_qa_op_code.h"
#include "ExtApp_qa_sep_parser.h"
#include "connectivitytest_msg_defs.h"
#include "crysatptest_msg_defs.h"
#include "extapp_err.h"
#include "sep_utils.h"
#include "extInt_msg_defs.h"
#include "timer_msg_defs.h"
#include "parser_atp_sst_authentication.h"
#include "parser_atp_sst_data.h"
#include "parser_atp_sst_special_data.h"
#include "parser_atp_sst_index.h"
#include "parser_atp_sst_iterators.h"
#include "parser_atp_sst_rollback.h"
#include "parser_atp_crys_sst_asym.h"
#include "parser_atp_crys_sst_sym.h"
#include "kmngatptest_msg_defs.h"
#include "parser_atp_init_terminate.h"
#include "parser_atp_sst_mm.h"
#include "parser_atp_sst_utils.h"


/************************ Defines ****************************/
/************************ Enums ******************************/
/************************ Typedefs ***************************/
/************************ Global Data ************************/



/*************************************************************************************   
*  @brief Decode the op-code for QA external SEP applications and call corresponding QA party parser.
*
*  @param msg_ptr		[in]	Pointer to the received message buffer in the shared memory
*  @param msgSize_ptr	[out]	Pointer to the Size of the sent message in the shared memory
*  @return DX_SUCCESS	The operation completed successfully.
*  @return DX_FAILURE	The operation failed.
**/
DxUint32_t APP3PARTY_SEPMainParser( DxUint32_t* msg_ptr, DxUint32_t* msgLen_ptr )
{
	/*opcode of the message*/
	DxUint32_t	opCode = 0;
	
    opCode = DX_SEP_GetMsgOpCode(msg_ptr);

	switch(opCode)
	{
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_CONNECTIVITY_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_ConnectivityTest(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_EXT_INT_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_ExIntHandler(msg_ptr);
			break;
        case DX_SEP_HOST_SEP_PROTOCOL_TIMER_INT_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_TimerHandler(msg_ptr);
            break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_AES_NotIntegrated_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_AESNotIntegratedTest(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_AES_Integrated_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_AESIntegratedTest(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_AES_MACNonIntegrated_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_AES_MACNonIntegratedTest(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_AES_XCBC_CMACNonIntegrated_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_AES_XCBC_CMACNonIntegratedTest(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_AES_XCBC_CMACIntegrated_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_AES_XCBC_CMACIntegratedTest(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_AES_MACIntegrated_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_AES_MACIntegratedTest(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_AES_KeyWrapUnwarp_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_AES_KeyWrapUnwarp(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_DES_NotIntegrated_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_DESNotIntegratedTest(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_DES_Integrated_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_DESIntegratedTest(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_HASH_NotIntegrated_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_HASHNotIntegratedTest(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_HASH_Integrated_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_HASHIntegratedTest(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_HMAC_NotIntegrated_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_HMACNotIntegratedTest(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_HMAC_Integrated_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_HMACIntegratedTest(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_RC4_NotIntegrated_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_RC4NotIntegratedTest(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_RC4_Integrated_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_RC4IntegratedTest(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_PRIME_EncDec_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_RSA_PRIME_EncDecTest(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_PRIME_SignVerify_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_RSA_PRIME_SignVerifyTest(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_PKCS1v15_EncDec_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_RSA_PKCS1v15_EncDec(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_PKCS1v15_NonIntegrate_SignVerify_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_RSA_PKCS1v15_NonIntegrate_SignVerify(msg_ptr);
			break;
			
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_PKCS1v15_Integrate_SignVerify_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_RSA_PKCS1v15_Integrate_SignVerify(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_PKCS1v15_ExternalHash_SignVerify_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_RSA_PKCS1v15_ExternalHash_SignVerify(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_PSS_ExternalHash_SignVerify_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_RSA_PSS_ExternalHash_SignVerify(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_Get_PrivAndPubKey_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_RSA_Get_PrivAndPubKey(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_OAEP_EncDec_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_RSA_OAEP_EncDec(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_PSS_NonIntegrate_SignVerify_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_RSA_PSS_NonIntegrate_SignVerify(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_PSS_Integrate_SignVerify_TEST_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_RSA_PSS_Integrate_SignVerify(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_ECC_ECDSA_NonIntegratedSignVerify:
			*msgLen_ptr = DX_SEP_PARSER_ECC_ECDSA_NonIntegratedSignVerify(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_ECC_ECDSA_IntegratedSignVerify:
			*msgLen_ptr = DX_SEP_PARSER_ECC_ECDSA_IntegratedSignVerify(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_ECC_DH:
			*msgLen_ptr = DX_SEP_PARSER_ECC_DH(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_ECC_ElGamal_EncDec:
			*msgLen_ptr = DX_SEP_PARSER_ECC_ElGamal_EncDec(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_ECC_ImportExportKeyPair:
			*msgLen_ptr = DX_SEP_PARSER_ECC_ImportExportKeyPair(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_DH_PKCS3:
			*msgLen_ptr = DX_SEP_PARSER_DH_PKCS3(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_DH_ANSI942:
			*msgLen_ptr = DX_SEP_PARSER_DH_ANSI942(msg_ptr);
			break;

		case DX_SEP_HOST_SEP_PROTOCOL_HOST_RND_No_Reset:
			*msgLen_ptr = DX_SEP_PARSER_RND_No_Reset(msg_ptr);
			break;
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_RND_Reset:
			*msgLen_ptr = DX_SEP_PARSER_RND_Reset(msg_ptr);
			break;

		/* KMNG */
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_ImportExportSymKeys:
			*msgLen_ptr = DX_SEP_PARSER_KMNG_ImportExportSymKeys(msg_ptr);
			break;

		case DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_ImportExportRSAKeys:
			*msgLen_ptr = DX_SEP_PARSER_KMNG_ImportExportRSAKeys(msg_ptr);
			break;

		case DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_AES_ActivateKey:
			*msgLen_ptr = DX_SEP_PARSER_KMNG_AES_ActivateKeys(msg_ptr);
			break;

		case DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_DES_ActivateKey:
			*msgLen_ptr = DX_SEP_PARSER_KMNG_DES_ActivateKeys(msg_ptr);
			break;

		case DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_HMAC_ActivateKey:
			*msgLen_ptr = DX_SEP_PARSER_KMNG_HMAC_ActivateKeys(msg_ptr);
			break;

		case DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_RSA_PRIME_ActivateKey:
			*msgLen_ptr = DX_SEP_PARSER_KMNG_RSA_PRIME_ActivateKeys(msg_ptr);
			break;

		case DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_RSA_V15_ActivateKey:
			*msgLen_ptr = DX_SEP_PARSER_KMNG_RSA_V15_ActivateKeys(msg_ptr);
			break;

		case DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_RSA_V21_ActivateKey:
			*msgLen_ptr = DX_SEP_PARSER_KMNG_RSA_V21_ActivateKeys(msg_ptr);
			break;

		/* SST */		
		case DX_SEP_HOST_SEP_PROTOCOL_SST_PasAuthenticator_OP_CODE:
			*msgLen_ptr = DX_SEP_SST_PARSER_PasswordAuthenticator(msg_ptr);
			break;

	   case DX_SEP_HOST_SEP_PROTOCOL_SST_RsaAsymAuthenticator_OP_CODE:
				*msgLen_ptr = DX_SEP_SST_PARSER_RsaAsymAuthenticator(msg_ptr);
				break;

	   case DX_SEP_HOST_SEP_PROTOCOL_SST_AesKeyAsymAuthenticator_OP_CODE:
				*msgLen_ptr = DX_SEP_SST_PARSER_AesKeyAsymAuthenticator(msg_ptr);
				break;

	   case DX_SEP_HOST_SEP_PROTOCOL_SST_ECCAsymAuthenticator_OP_CODE:
				*msgLen_ptr = DX_SEP_SST_PARSER_ECCAsymAuthenticator(msg_ptr);
				break;

		case DX_SEP_HOST_SEP_PROTOCOL_SST_SpecialDataAES_OP_CODE:
		   *msgLen_ptr = DX_SEP_SST_PARSER_SpecialDataOpAES(msg_ptr);
				break;


		case DX_SEP_HOST_SEP_PROTOCOL_SST_SpecialDataDES_OP_CODE:
		   *msgLen_ptr = DX_SEP_SST_PARSER_SpecialDataOpDES(msg_ptr);
				break;

		case DX_SEP_HOST_SEP_PROTOCOL_SST_SpecialDataHMAC_OP_CODE:
		   *msgLen_ptr = DX_SEP_SST_PARSER_SpecialDataOpHMAC(msg_ptr);
				break;

		case DX_SEP_HOST_SEP_PROTOCOL_SST_SpecialDataRSA_OP_CODE:
			*msgLen_ptr = DX_SEP_SST_PARSER_SpecialDataOpRSA(msg_ptr);
			break;

		case DX_SEP_HOST_SEP_PROTOCOL_SST_ReadOnlyData_OP_CODE:
			*msgLen_ptr = DX_SEP_SST_PARSER_ReadOnlyData(msg_ptr);
			break;


		case DX_SEP_HOST_SEP_PROTOCOL_SST_BasicDataOp_OP_CODE:
			*msgLen_ptr = DX_SEP_SST_PARSER_BasicDataOp(msg_ptr);
			break;

		case DX_SEP_HOST_SEP_PROTOCOL_SST_BasicUnAuthnticatedDataOp_OP_CODE:
			*msgLen_ptr = DX_SEP_SST_PARSER_BasicUnAuthnticatedDataOp(msg_ptr);
			break;

		case DX_SEP_HOST_SEP_PROTOCOL_SST_BindingWritingPermissions_OP_CODE:
			*msgLen_ptr = DX_SEP_SST_PARSER_BindingWritingPermissions(msg_ptr);
			break;

		case DX_SEP_HOST_SEP_PROTOCOL_SST_DataReplace_OP_CODE:
			*msgLen_ptr = DX_SEP_SST_PARSER_DataReplace(msg_ptr);
			break;

		case DX_SEP_HOST_SEP_PROTOCOL_SST_Index_OP_CODE:
		   *msgLen_ptr = DX_SEP_SST_PARSER_Index(msg_ptr);
				break;

		case DX_SEP_HOST_SEP_PROTOCOL_SST_Iterator_OP_CODE:
		   *msgLen_ptr = DX_SEP_SST_PARSER_Iterator(msg_ptr);
				break;

		case DX_SEP_HOST_SEP_PROTOCOL_SST_RollBack_OP_CODE:
			*msgLen_ptr = DX_SEP_SST_PARSER_RollBack(msg_ptr);
				break;

		case DX_SEP_HOST_SEP_PROTOCOL_CRYS_SST_RSA_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_CRYS_SST_RSA(msg_ptr);
				 break;

		case DX_SEP_HOST_SEP_PROTOCOL_CRYS_SST_DES_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_CRYS_SST_DES(msg_ptr);
				 break;

		case DX_SEP_HOST_SEP_PROTOCOL_CRYS_SST_HMAC_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_CRYS_SST_HMAC(msg_ptr);
				 break;

		case DX_SEP_HOST_SEP_PROTOCOL_CRYS_SST_AES_OP_CODE:
			*msgLen_ptr = DX_SEP_PARSER_CRYS_SST_AES(msg_ptr);
				 break;

		case DX_SEP_HOST_SEP_PROTOCOL_CRYS_SST_RSA_OAEP_ENCDEC_OP_CODE:
			 *msgLen_ptr = DX_SEP_PARSER_CRYS_SST_RSA_OAEP_ENCDEC(msg_ptr);
		break;

		case DX_SEP_HOST_SEP_PROTOCOL_CRYS_SST_RSA_PRIM_OP_CODE:
			 *msgLen_ptr = DX_SEP_PARSER_CRYS_SST_RSA_PRIM(msg_ptr);
		break;

		case DX_SEP_HOST_SEP_PROTOCOL_SST_InitTerminate_1_OP_CODE:
			 *msgLen_ptr = DX_SEP_PARSER_SST_InitTerminate_1(msg_ptr);
		break;


		case DX_SEP_HOST_SEP_PROTOCOL_SST_InitTerminate_2_OP_CODE:
			 *msgLen_ptr = DX_SEP_PARSER_SST_InitTerminate_2(msg_ptr);
		break;


    case DX_SEP_HOST_SEP_PROTOCOL_SST_Utility_Handle_OP_CODE:
         *msgLen_ptr = DX_SEP_PARSER_SST_Utility_Handle(msg_ptr);
    break;

    case DX_SEP_HOST_SEP_PROTOCOL_SST_Utility_Size_OP_CODE:
         *msgLen_ptr = DX_SEP_SST_PARSER_Utility_Size(msg_ptr);
    break;

    case DX_SEP_HOST_SEP_PROTOCOL_SST_MM_1_OP_CODE:
         *msgLen_ptr = DX_SEP_PARSER_SST_MM_1(msg_ptr);
    break;

    case DX_SEP_HOST_SEP_PROTOCOL_SST_MM_2_OP_CODE:
         *msgLen_ptr = DX_SEP_PARSER_SST_MM_2(msg_ptr);
    break;

		case DX_SEP_HOST_SEP_PROTOCOL_HOST_REQ1_OP_CODE:
			/* call spesific parser and set msgLen */
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_REQ2_OP_CODE:
			/* call spesific parser and set msgLen */
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_REQ3_OP_CODE:
			/* call spesific parser and set msgLen */
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_REQ4_OP_CODE:
			/* call spesific parser and set msgLen */
		case DX_SEP_HOST_SEP_PROTOCOL_HOST_REQ5_OP_CODE:
			/* call spesific parser and set msgLen */

		default:
			return DX_FAILURE;
	}

	return DX_SUCCESS;
}

int main()
{
	DxUint32_t msg[20];
	DxUint32_t msgLen;
	msgLen = APP3PARTY_SEPMainParser(msg, &msgLen);

	return msgLen;
}





